(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17933,        705]*)
(*NotebookOutlinePosition[     18773,        732]*)
(*  CellTagsIndexPosition[     18729,        728]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Subsection"],

Cell[StyleData[All, "Working"],
  CellBracketOptions->{"Color"->RGBColor[0, 0.2, 1]},
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Subsection"],

Cell["\<\
  The options defined for the style below will be used at the \
Notebook level.  \
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            OptionValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            OptionValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PrintingOptions->{"FirstPageHeader"->False,
  "FacingPages"->True},
  CellLabelAutoDelete->False,
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Headings", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{5, Inherited}, {2, 0}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Times",
  FontSize->36,
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0, 0, 1]],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{0, 10}, {2, 0}},
  FontSize->28,
  Background->GrayLevel[0.6]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{12, Inherited}, {2, 2}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{7, 10}, {2, 4}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{12, Inherited}, {2, 12}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{7, 10}, {2, 8}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{6, 0.5}, {0.5, 0.5}},
  CellMargins->{{8, 4}, {2, 50}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0, 0, 1],
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Section", "Printout"],
  CellFrame->{{6, 0.5}, {0.5, 0.5}},
  CellMargins->{{6, 4}, {2, 70}},
  CellFrameColor->GrayLevel[0],
  FontSize->14,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{24, 4}, {2, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->12},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->15,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{19, 4}, {2, 18}},
  FontSize->12,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellMargins->{{10, 4}, {2, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->12},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{7, 4}, {2, 18}},
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Text", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 12},
  CounterIncrements->"Text",
  FontSize->14],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{7, 0}, {0, 8}},
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MathCaption"],
  CellFrame->{{3, 0}, {0, 0.5}},
  CellMargins->{{47, 14}, {0, 14}},
  CellFrameColor->RGBColor[0, 0, 1],
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 8},
  FontFamily->"Helvetica",
  FontSize->12],

Cell[StyleData["MathCaption", "Printout"],
  CellMargins->{{34, 54}, {0, 14}},
  CellFrameColor->GrayLevel[0],
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Input/Output", "Subsection"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{54, 14}, {3, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["Input", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{43, 4}, {3, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{55, 4}, {8, 3}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->StandardForm,
  CounterIncrements->"Output",
  FontSize->14],

Cell[StyleData["Output", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{43, 4}, {4, 2}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{56, 4}, {3, 8}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0.2, 1]],

Cell[StyleData["Message", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{44, 4}, {3, 8}},
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{56, 4}, {3, 8}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{44, 4}, {3, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{55, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{42, 4}, {3, 8}},
  ImageSize->{250, 250},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0.2, 1]],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->7,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["ItemizedText"],
  CellMargins->{{26, 4}, {0, 8}},
  ShowSpecialCharacters->Automatic,
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 8},
  ParagraphIndent->-19,
  CounterIncrements->"Text",
  FontSize->14],

Cell[StyleData["ItemizedText", "Printout"],
  CellMargins->{{20, 4}, {0, 8}},
  ParagraphIndent->-14,
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextNote"],
  CellMargins->{{45, 4}, {0, 5}},
  ShowSpecialCharacters->Automatic,
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 5},
  CounterIncrements->"Text",
  FontSize->14],

Cell[StyleData["ItemizedTextNote", "Printout"],
  CellMargins->{{34, 4}, {0, 4}},
  ParagraphSpacing->{0, 4},
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndentedText"],
  CellMargins->{{26, 4}, {0, 8}},
  ShowSpecialCharacters->Automatic,
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text",
  FontSize->14],

Cell[StyleData["IndentedText", "Printout"],
  CellMargins->{{20, 4}, {0, 8}},
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Note"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0, 0, 1],
  ShowSpecialCharacters->Automatic,
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text",
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["Note", "Printout"],
  CellMargins->{{7, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
  CellMargins->{{10, Inherited}, {0, 8}},
  CellHorizontalScrolling->True],

Cell[StyleData["Picture", "Printout"],
  CellMargins->{{7, Inherited}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
  CellMargins->{{10, 50}, {0, 3}},
  PageBreakAbove->False,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Caption", "Printout"],
  CellMargins->{{7, 50}, {2, 4}},
  FontSize->7,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["2ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  GridBoxOptions->{ColumnWidths->{0.39, 0.59},
  ColumnAlignments->{Left}}],

Cell[StyleData["2ColumnTable", "Printout"],
  CellMargins->{{7, 4}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.325,
  ColumnAlignments->{Left}}],

Cell[StyleData["3ColumnTable", "Printout"],
  CellMargins->{{7, 4}, {0, 8}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
  CellMargins->{{55, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  AutoSpacing->False,
  ScriptLevel->1,
  ScriptBaselineShifts->{0.6, Automatic},
  SingleLetterItalics->False,
  ZeroWidthTimes->True,
  FontSize->14],

Cell[StyleData["ChemicalFormula", "Printout"],
  CellMargins->{{43, Inherited}, {Inherited, Inherited}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{55, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  ScriptLevel->0,
  SingleLetterItalics->True,
  FontSize->14,
  UnderoverscriptBoxOptions->{LimitsPositioning->True},
  GridBoxOptions->{ColumnWidths->Automatic}],

Cell[StyleData["DisplayFormula", "Printout"],
  CellMargins->{{43, Inherited}, {Inherited, Inherited}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{10, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  FontFamily->"Courier"],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Subsection"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->GrayLevel[1],
  Background->RGBColor[0, 0.6, 1],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None",
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->GrayLevel[1],
  Background->RGBColor[0, 0.6, 1],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->GrayLevel[1],
  Background->RGBColor[0, 0.6, 1],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnLink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->GrayLevel[1],
  Background->RGBColor[0, 0.6, 1],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->GrayLevel[1],
  Background->RGBColor[0, 0.6, 1],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->GrayLevel[1],
  Background->RGBColor[0, 0.6, 1],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{497, 311},
WindowMargins->{{11, Automatic}, {Automatic, 3}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 62, "Subtitle"],
Cell[1771, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 45, 0, 46, "Subsection"],
Cell[2037, 63, 105, 2, 36, 31, 0, "StyleData", "All", "Working"],
Cell[2145, 67, 104, 2, 36, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2286, 74, 38, 0, 30, "Subsection"],
Cell[2327, 76, 105, 3, 30, "Text"],
Cell[2435, 81, 538, 14, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3010, 100, 30, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[3065, 104, 400, 11, 70, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3468, 117, 116, 3, 62, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3621, 125, 313, 8, 55, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[3937, 135, 89, 2, 40, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4063, 142, 316, 8, 45, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4382, 152, 92, 2, 39, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4511, 159, 452, 12, 71, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[4966, 173, 184, 5, 119, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5187, 183, 428, 12, 45, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[5618, 197, 119, 3, 49, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5774, 205, 310, 8, 43, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[6087, 215, 121, 3, 47, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6257, 224, 26, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[6308, 228, 187, 6, 39, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[6498, 236, 84, 2, 35, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6619, 243, 230, 7, 49, 30, 0, "StyleData", "MathCaption", "All"],
Cell[6852, 252, 126, 3, 49, 42, 0, "StyleData", "MathCaption", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7027, 261, 34, 0, 30, "Subsection"],
Cell[7064, 263, 252, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[7341, 272, 453, 14, 43, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[7797, 288, 112, 3, 38, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7946, 296, 439, 13, 43, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[8388, 311, 113, 3, 33, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8538, 319, 479, 14, 35, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[9020, 335, 141, 4, 38, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9198, 344, 441, 13, 35, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[9642, 359, 112, 3, 38, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9791, 367, 389, 11, 36, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[10183, 380, 113, 3, 37, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10333, 388, 130, 4, 34, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[10466, 394, 106, 3, 31, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10621, 403, 35, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[10681, 407, 221, 7, 39, 31, 0, "StyleData", "ItemizedText", "All",
  CounterIncrements->"Text"],
Cell[10905, 416, 117, 3, 35, 43, 0, "StyleData", "ItemizedText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11059, 424, 201, 6, 35, 35, 0, "StyleData", "ItemizedTextNote", "All",
  CounterIncrements->"Text"],
Cell[11263, 432, 125, 3, 31, 47, 0, "StyleData", "ItemizedTextNote", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11425, 440, 197, 6, 35, 31, 0, "StyleData", "IndentedText", "All",
  CounterIncrements->"Text"],
Cell[11625, 448, 93, 2, 35, 43, 0, "StyleData", "IndentedText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11755, 455, 305, 10, 47, 23, 0, "StyleData", "Note", "All",
  CounterIncrements->"Text"],
Cell[12063, 467, 115, 3, 48, 35, 0, "StyleData", "Note", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12215, 475, 101, 2, 32, 26, 0, "StyleData", "Picture", "All"],
Cell[12319, 479, 79, 1, 36, 38, 0, "StyleData", "Picture", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12435, 485, 160, 5, 30, 26, 0, "StyleData", "Caption", "All"],
Cell[12598, 492, 114, 3, 29, 38, 0, "StyleData", "Caption", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12761, 501, 28, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[12814, 505, 174, 4, 36, 31, 0, "StyleData", "2ColumnTable", "All"],
Cell[12991, 511, 92, 2, 35, 43, 0, "StyleData", "2ColumnTable", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13120, 518, 193, 5, 40, 31, 0, "StyleData", "3ColumnTable", "All",
  StyleMenuListing->None],
Cell[13316, 525, 92, 2, 35, 43, 0, "StyleData", "3ColumnTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13457, 533, 46, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[13528, 537, 322, 9, 39, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[13853, 548, 120, 2, 35, 46, 0, "StyleData", "ChemicalFormula", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14010, 555, 333, 8, 39, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[14346, 565, 119, 2, 35, 45, 0, "StyleData", "DisplayFormula", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[14502, 572, 142, 3, 36, 26, 0, "StyleData", "Program", "All"],
Cell[14647, 577, 112, 2, 35, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14808, 585, 38, 0, 30, "Subsection"],
Cell[14849, 587, 184, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[15058, 595, 316, 9, 52, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[15377, 606, 95, 2, 36, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[15487, 611, 104, 3, 35, "Text"],

Cell[CellGroupData[{
Cell[15616, 618, 307, 8, 52, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[15926, 628, 98, 2, 36, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16061, 635, 328, 9, 60, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[16392, 646, 95, 2, 36, 40, 0, "StyleData", "AddOnLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16524, 653, 336, 9, 60, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[16863, 664, 98, 2, 36, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16998, 671, 319, 8, 60, 37, 0, "StyleData", "GettingStartedLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[17320, 681, 104, 2, 36, 49, 0, "StyleData", "GettingStartedLink", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[17461, 688, 323, 8, 60, 39, 0, "StyleData", "OtherInformationLink", 
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[17787, 698, 106, 2, 36, 51, 0, "StyleData", "OtherInformationLink", 
"Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

